/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.table;

import com.orsoncharts.data.DefaultKeyedValues2D;
import com.orsoncharts.table.AbstractTableElement;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TableElementOnDraw;
import com.orsoncharts.table.TableElementVisitor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GridElement
extends AbstractTableElement
implements TableElement,
Serializable {
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private DefaultKeyedValues2D<TableElement> elements = new DefaultKeyedValues2D();

    public GridElement() {
        this.setBackgroundColor(TRANSPARENT_COLOR);
    }

    public void setElement(TableElement element, Comparable<?> rowKey, Comparable<?> columnKey) {
        this.elements.setValue(element, rowKey, columnKey);
    }

    @Override
    public void receive(TableElementVisitor visitor) {
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            for (int c = 0; c < this.elements.getColumnCount(); ++c) {
                TableElement element = this.elements.getValue(r, c);
                if (element == null) continue;
                element.receive(visitor);
            }
        }
        visitor.visit(this);
    }

    private double[][] findCellDimensions(Graphics2D g2, Rectangle2D bounds) {
        int rowCount = this.elements.getRowCount();
        int columnCount = this.elements.getColumnCount();
        double[] widths = new double[columnCount];
        double[] heights = new double[rowCount];
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            for (int c = 0; c < this.elements.getColumnCount(); ++c) {
                TableElement element = this.elements.getValue(r, c);
                if (element == null) continue;
                Dimension2D dim = element.preferredSize(g2, bounds);
                widths[c] = Math.max(widths[c], dim.getWidth());
                heights[r] = Math.max(heights[r], dim.getHeight());
            }
        }
        return new double[][]{widths, heights};
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        Insets insets = this.getInsets();
        double[][] cellDimensions = this.findCellDimensions(g2, bounds);
        double[] widths = cellDimensions[0];
        double[] heights = cellDimensions[1];
        double w = insets.left + insets.right;
        for (int i = 0; i < widths.length; ++i) {
            w += widths[i];
        }
        double h = insets.top + insets.bottom;
        for (int i = 0; i < heights.length; ++i) {
            h += heights[i];
        }
        return new Dimension((int)w, (int)h);
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        double[][] cellDimensions = this.findCellDimensions(g2, bounds);
        double[] widths = cellDimensions[0];
        double[] heights = cellDimensions[1];
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(this.elements.getRowCount() * this.elements.getColumnCount());
        double y = bounds.getY() + (double)this.getInsets().top;
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            double x = bounds.getX() + (double)this.getInsets().left;
            for (int c = 0; c < this.elements.getColumnCount(); ++c) {
                result.add(new Rectangle2D.Double(x, y, widths[c], heights[r]));
                x += widths[c];
            }
            y += heights[r];
        }
        return result;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        this.draw(g2, bounds, null);
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds, TableElementOnDraw onDrawHandler) {
        if (onDrawHandler != null) {
            onDrawHandler.beforeDraw(this, g2, bounds);
        }
        if (this.getBackground() != null) {
            this.getBackground().fill(g2, bounds);
        }
        List<Rectangle2D> positions = this.layoutElements(g2, bounds, null);
        for (int r = 0; r < this.elements.getRowCount(); ++r) {
            for (int c = 0; c < this.elements.getColumnCount(); ++c) {
                TableElement element = this.elements.getValue(r, c);
                if (element == null) continue;
                Rectangle2D pos = positions.get(r * this.elements.getColumnCount() + c);
                element.draw(g2, pos, onDrawHandler);
            }
        }
        if (onDrawHandler != null) {
            onDrawHandler.afterDraw(this, g2, bounds);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridElement)) {
            return false;
        }
        GridElement that = (GridElement)obj;
        return this.elements.equals(that.elements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GridElement[rowCount=").append(this.elements.getRowCount());
        sb.append(", columnCount=").append(this.elements.getColumnCount());
        sb.append("]");
        return sb.toString();
    }
}

