/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.util;

import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.RefPt2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public final class Anchor2D
implements Serializable {
    public static final Anchor2D TOP_LEFT = new Anchor2D(RefPt2D.TOP_LEFT, Offset2D.ZERO_OFFSET);
    public static final Anchor2D TOP_CENTER = new Anchor2D(RefPt2D.TOP_CENTER, Offset2D.ZERO_OFFSET);
    public static final Anchor2D TOP_RIGHT = new Anchor2D(RefPt2D.TOP_RIGHT, Offset2D.ZERO_OFFSET);
    public static final Anchor2D CENTER_LEFT = new Anchor2D(RefPt2D.CENTER_LEFT, Offset2D.ZERO_OFFSET);
    public static final Anchor2D CENTER = new Anchor2D(RefPt2D.CENTER, Offset2D.ZERO_OFFSET);
    public static final Anchor2D CENTER_RIGHT = new Anchor2D(RefPt2D.CENTER_RIGHT, Offset2D.ZERO_OFFSET);
    public static final Anchor2D BOTTOM_LEFT = new Anchor2D(RefPt2D.BOTTOM_LEFT, Offset2D.ZERO_OFFSET);
    public static final Anchor2D BOTTOM_CENTER = new Anchor2D(RefPt2D.BOTTOM_CENTER, Offset2D.ZERO_OFFSET);
    public static final Anchor2D BOTTOM_RIGHT = new Anchor2D(RefPt2D.BOTTOM_RIGHT, Offset2D.ZERO_OFFSET);
    private RefPt2D refPt;
    private Offset2D offset;

    public Anchor2D() {
        this(RefPt2D.TOP_LEFT);
    }

    public Anchor2D(RefPt2D refPt) {
        this(refPt, new Offset2D(4.0, 4.0));
    }

    public Anchor2D(RefPt2D refPt, Offset2D offset) {
        ArgChecks.nullNotPermitted((Object)refPt, "refPt");
        ArgChecks.nullNotPermitted(offset, "offset");
        this.refPt = refPt;
        this.offset = offset;
    }

    public RefPt2D getRefPt() {
        return this.refPt;
    }

    public Offset2D getOffset() {
        return this.offset;
    }

    public Point2D getAnchorPoint(Rectangle2D rect) {
        ArgChecks.nullNotPermitted(rect, "rect");
        double x = 0.0;
        double y = 0.0;
        if (this.refPt.isLeft()) {
            x = rect.getX() + this.offset.getDX();
        } else if (this.refPt.isHorizontalCenter()) {
            x = rect.getCenterX();
        } else if (this.refPt.isRight()) {
            x = rect.getMaxX() - this.offset.getDX();
        }
        if (this.refPt.isTop()) {
            y = rect.getMinY() + this.offset.getDY();
        } else if (this.refPt.isVerticalCenter()) {
            y = rect.getCenterY();
        } else if (this.refPt.isBottom()) {
            y = rect.getMaxY() - this.offset.getDY();
        }
        return new Point2D.Double(x, y);
    }

    public Point2D resolveAnchorWithPercentOffset(double startX, double startY, double endX, double endY) {
        double x = 0.0;
        double y = 0.0;
        if (this.refPt.isLeft()) {
            x = startX + this.offset.getDX() * (endX - startX);
        } else if (this.refPt.isHorizontalCenter()) {
            x = (startX + endX) / 2.0;
        } else if (this.refPt.isRight()) {
            x = endX - this.offset.getDX() * (endX - startX);
        }
        if (this.refPt.isTop()) {
            y = endY - this.offset.getDY() * (endY - startY);
        } else if (this.refPt.isVerticalCenter()) {
            y = (startY + endY) / 2.0;
        } else if (this.refPt.isBottom()) {
            y = startY + this.offset.getDY() * (endY - startY);
        }
        return new Point2D.Double(x, y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Anchor2D)) {
            return false;
        }
        Anchor2D that = (Anchor2D)obj;
        if (!this.refPt.equals((Object)that.refPt)) {
            return false;
        }
        return this.offset.equals(that.offset);
    }
}

