/*
 * Decompiled with CFR 0.152.
 */
package smsimulator.Controler;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import smsimulator.Controler.MediatorInterface;
import smsimulator.model.InvestorsCompaniesCreator;
import smsimulator.model.TradingDaySimulation;
import smsimulator.model.company.Company;
import smsimulator.model.company.MySQLCompanyDAO;
import smsimulator.model.investor.Investor;
import smsimulator.model.investor.MySQLInvestorDAO;
import smsimulator.model.transaction.MySQLTransactionDAO;
import smsimulator.model.transaction.Transaction;
import smsimulator.view.Component;
import smsimulator.view.GUIBarChartSummary;
import smsimulator.view.GUIMenuBar;
import smsimulator.view.GUIOptionPane;
import smsimulator.view.GUITableCompanies;
import smsimulator.view.GUITableInvestors;
import smsimulator.view.GUITableTransactions;
import smsimulator.view.GUITablesSummary;
import smsimulator.view.MainFrame;

public class Mediator
implements MediatorInterface {
    private ArrayList<Investor> investors;
    private ArrayList<Company> companies;
    private ArrayList<Transaction> transactions;
    private int numberCompanies = 10;
    private int numberInvestors = 10;
    private JFrame frame;
    private GUITableInvestors tableInvestors;
    private GUITableCompanies tableCompanies;
    private GUITableTransactions tableTransactions;
    private GUIMenuBar menuBar;
    private GUIBarChartSummary barChart;
    private GUITablesSummary tableSummary;
    private GUIOptionPane optionPane;
    private JPanel panelTransactions;
    private JPanel panelInvestors;
    private JPanel panelCompanies;
    private JPanel panelSummary;
    private JPanel panelS;
    private JPanel panelCompaniesMaxcapital;
    private JPanel panelCompaniesMincapital;
    private JPanel panelInvestorsMaxShares;
    private JPanel panelInvestorsMinShares;
    private JPanel panelInvestorsMaxCompanies;
    private JPanel panelInvestorsMinCompanies;
    private boolean newSim;

    public Mediator(ArrayList<Investor> investors, ArrayList<Company> companies, ArrayList<Transaction> transactions) {
        this.investors = investors;
        this.companies = companies;
        this.transactions = transactions;
    }

    @Override
    public void registerComponent(Component component) {
        component.setMediator(this);
        switch (component.getName()) {
            case "PanelInvestors": {
                this.tableInvestors = (GUITableInvestors)component;
                break;
            }
            case "PanelCompanies": {
                this.tableCompanies = (GUITableCompanies)component;
                break;
            }
            case "PanelTransactions": {
                this.tableTransactions = (GUITableTransactions)component;
                break;
            }
            case "MenuBar": {
                this.menuBar = (GUIMenuBar)component;
                break;
            }
            case "BarChart": {
                this.barChart = (GUIBarChartSummary)component;
                break;
            }
            case "GUITablesSummary": {
                this.tableSummary = (GUITablesSummary)component;
                break;
            }
            case "GUIOptionPane": {
                this.optionPane = (GUIOptionPane)component;
            }
        }
    }

    @Override
    public void createGUI() {
        this.frame = new MainFrame("Stock Market Simulator", 1145, 685, "src/smsimulator/view/icon.png");
        this.frame.setJMenuBar(this.menuBar);
        GridLayout grid1 = new GridLayout(2, 2);
        this.frame.setLayout(grid1);
        this.panelTransactions = new JPanel();
        this.panelTransactions.setBorder(BorderFactory.createTitledBorder(null, "Transactions", 0, 0, new Font("PLAIN", 1, 12)));
        this.panelTransactions.setToolTipText("Transactions");
        JScrollPane scrollPaneT = new JScrollPane(this.tableTransactions.createTableTransactions(this.transactions));
        scrollPaneT.setPreferredSize(new Dimension(510, 300));
        this.panelTransactions.add(scrollPaneT);
        this.panelTransactions.revalidate();
        this.frame.add(this.panelTransactions);
        this.panelSummary = new JPanel();
        this.panelSummary.setBorder(BorderFactory.createTitledBorder(null, "Summary of the Simulation", 0, 0, new Font("PLAIN", 1, 12)));
        GridLayout gridp2 = new GridLayout(1, 1);
        this.panelSummary.setLayout(gridp2);
        this.panelS = new JPanel();
        GridLayout grid21 = new GridLayout(3, 2);
        this.panelS.setLayout(grid21);
        this.panelCompaniesMaxcapital = new JPanel();
        this.panelCompaniesMaxcapital.setBorder(BorderFactory.createTitledBorder(null, "Companies with the highest capital", 0, 0, new Font("PLAIN", 1, 11)));
        JScrollPane scrollPaneCompMaxCapital = new JScrollPane(this.tableSummary.createTableCompaniesMaxCapital(this.transactions, this.companies));
        scrollPaneCompMaxCapital.setPreferredSize(new Dimension(245, 75));
        this.panelCompaniesMaxcapital.add(scrollPaneCompMaxCapital);
        this.panelS.add(this.panelCompaniesMaxcapital);
        this.panelCompaniesMincapital = new JPanel();
        this.panelCompaniesMincapital.setBorder(BorderFactory.createTitledBorder(null, "Companies with the lowest capital", 0, 0, new Font("PLAIN", 1, 11)));
        JScrollPane scrollPaneCompMinCapital = new JScrollPane(this.tableSummary.createTableCompaniesMinCapital(this.transactions, this.companies));
        scrollPaneCompMinCapital.setPreferredSize(new Dimension(245, 75));
        this.panelCompaniesMincapital.add(scrollPaneCompMinCapital);
        this.panelS.add(this.panelCompaniesMincapital);
        this.panelInvestorsMaxShares = new JPanel();
        this.panelInvestorsMaxShares.setBorder(BorderFactory.createTitledBorder(null, "Investor with the highest # of shares", 0, 0, new Font("PLAIN", 1, 11)));
        JScrollPane scrollPaneInveMaxShares = new JScrollPane(this.tableSummary.createTableInvestorsMaxShares(this.transactions, this.investors));
        scrollPaneInveMaxShares.setPreferredSize(new Dimension(245, 75));
        this.panelInvestorsMaxShares.add(scrollPaneInveMaxShares);
        this.panelS.add(this.panelInvestorsMaxShares);
        this.panelInvestorsMinShares = new JPanel();
        this.panelInvestorsMinShares.setBorder(BorderFactory.createTitledBorder(null, "Investor with the lowest # of shares", 0, 0, new Font("PLAIN", 1, 11)));
        JScrollPane scrollPaneInveMinShares = new JScrollPane(this.tableSummary.createTableInvestorsMinShares(this.transactions, this.investors));
        scrollPaneInveMinShares.setPreferredSize(new Dimension(245, 75));
        this.panelInvestorsMinShares.add(scrollPaneInveMinShares);
        this.panelS.add(this.panelInvestorsMinShares);
        this.panelInvestorsMaxCompanies = new JPanel();
        this.panelInvestorsMaxCompanies.setBorder(BorderFactory.createTitledBorder(null, "Investors that invested in most COs", 0, 0, new Font("PLAIN", 1, 11)));
        JScrollPane scrollPaneInveMaxComp = new JScrollPane(this.tableSummary.createTableInvestorsMaxCompanies(this.transactions, this.companies, this.investors));
        scrollPaneInveMaxComp.setPreferredSize(new Dimension(245, 75));
        this.panelInvestorsMaxCompanies.add(scrollPaneInveMaxComp);
        this.panelS.add(this.panelInvestorsMaxCompanies);
        this.panelInvestorsMinCompanies = new JPanel();
        this.panelInvestorsMinCompanies.setBorder(BorderFactory.createTitledBorder(null, "Investors that invested in less COs", 0, 0, new Font("PLAIN", 1, 11)));
        JScrollPane scrollPaneInveMinComp = new JScrollPane(this.tableSummary.createTableInvestorsMinCompanies(this.transactions, this.companies, this.investors));
        scrollPaneInveMinComp.setPreferredSize(new Dimension(245, 75));
        this.panelInvestorsMinCompanies.add(scrollPaneInveMinComp);
        this.panelS.add(this.panelInvestorsMinCompanies);
        this.panelSummary.add(this.panelS);
        this.frame.add(this.panelSummary);
        this.panelInvestors = new JPanel();
        this.panelInvestors.setBorder(BorderFactory.createTitledBorder(null, "Investors", 0, 0, new Font("PLAIN", 1, 12)));
        this.panelInvestors.setToolTipText("Investors");
        JScrollPane scrollPaneI = new JScrollPane(this.tableInvestors.createTableInvestors(this.investors));
        scrollPaneI.setPreferredSize(new Dimension(510, 300));
        this.panelInvestors.add(scrollPaneI);
        this.panelInvestors.revalidate();
        this.frame.add(this.panelInvestors);
        this.panelCompanies = new JPanel();
        this.panelCompanies.setBorder(BorderFactory.createTitledBorder(null, "Companies", 0, 0, new Font("PLAIN", 1, 12)));
        this.panelCompanies.setToolTipText("Companies");
        JScrollPane scrollPanelC = new JScrollPane(this.tableCompanies.createTableCompanies(this.companies));
        scrollPanelC.setPreferredSize(new Dimension(510, 300));
        this.panelCompanies.add(scrollPanelC);
        this.panelCompanies.revalidate();
        this.frame.add(this.panelCompanies);
        this.frame.setVisible(true);
        this.frame.validate();
        this.frame.repaint();
    }

    @Override
    public void newSimulation() {
        InvestorsCompaniesCreator setup = new InvestorsCompaniesCreator();
        this.optionPane.inputDialog();
        if (this.newSim) {
            Company.idAutoIncrement = 0;
            Investor.idAutoIncrement = 0;
            Transaction.idAutoIncrement = 0;
            setup.setCompanies(this.numberCompanies);
            setup.setInvestors(this.numberInvestors);
            this.companies = setup.getCompanies();
            this.investors = setup.getInvestors();
            TradingDaySimulation tds = new TradingDaySimulation();
            this.transactions = tds.tradingSimulator(this.companies, this.investors);
            this.registerComponent(new GUITableTransactions());
            this.registerComponent(new GUITableInvestors());
            this.registerComponent(new GUITableCompanies());
            JScrollPane scrollPaneT = new JScrollPane(this.tableTransactions.createTableTransactions(this.transactions));
            scrollPaneT.setPreferredSize(new Dimension(510, 300));
            JScrollPane ScrollPaneI = new JScrollPane(this.tableInvestors.createTableInvestors(this.investors));
            ScrollPaneI.setPreferredSize(new Dimension(510, 300));
            JScrollPane scrollPaneC = new JScrollPane(this.tableCompanies.createTableCompanies(this.companies));
            scrollPaneC.setPreferredSize(new Dimension(510, 300));
            JScrollPane scrollPaneCompMaxCapital = new JScrollPane(this.tableSummary.createTableCompaniesMaxCapital(this.transactions, this.companies));
            scrollPaneCompMaxCapital.setPreferredSize(new Dimension(245, 75));
            JScrollPane scrollPaneCompMinCapital = new JScrollPane(this.tableSummary.createTableCompaniesMinCapital(this.transactions, this.companies));
            scrollPaneCompMinCapital.setPreferredSize(new Dimension(245, 75));
            JScrollPane scrollPaneInveMaxShares = new JScrollPane(this.tableSummary.createTableInvestorsMaxShares(this.transactions, this.investors));
            scrollPaneInveMaxShares.setPreferredSize(new Dimension(245, 75));
            JScrollPane scrollPaneInveMinShares = new JScrollPane(this.tableSummary.createTableInvestorsMinShares(this.transactions, this.investors));
            scrollPaneInveMinShares.setPreferredSize(new Dimension(245, 75));
            JScrollPane scrollPaneInveMaxComp = new JScrollPane(this.tableSummary.createTableInvestorsMaxCompanies(this.transactions, this.companies, this.investors));
            scrollPaneInveMaxComp.setPreferredSize(new Dimension(245, 75));
            JScrollPane scrollPaneInveMinComp = new JScrollPane(this.tableSummary.createTableInvestorsMinCompanies(this.transactions, this.companies, this.investors));
            scrollPaneInveMinComp.setPreferredSize(new Dimension(245, 75));
            this.panelTransactions.removeAll();
            this.panelTransactions.repaint();
            this.panelTransactions.add(scrollPaneT);
            this.panelTransactions.revalidate();
            this.panelInvestors.removeAll();
            this.panelInvestors.repaint();
            this.panelInvestors.revalidate();
            this.panelInvestors.add(ScrollPaneI);
            this.panelCompanies.removeAll();
            this.panelCompanies.repaint();
            this.panelCompanies.revalidate();
            this.panelCompanies.add(scrollPaneC);
            this.panelCompaniesMaxcapital.removeAll();
            this.panelCompaniesMaxcapital.repaint();
            this.panelCompaniesMaxcapital.revalidate();
            this.panelCompaniesMaxcapital.add(scrollPaneCompMaxCapital);
            this.panelCompaniesMincapital.removeAll();
            this.panelCompaniesMincapital.repaint();
            this.panelCompaniesMincapital.revalidate();
            this.panelCompaniesMincapital.add(scrollPaneCompMinCapital);
            this.panelInvestorsMaxShares.removeAll();
            this.panelInvestorsMaxShares.repaint();
            this.panelInvestorsMaxShares.revalidate();
            this.panelInvestorsMaxShares.add(scrollPaneInveMaxShares);
            this.panelInvestorsMinShares.removeAll();
            this.panelInvestorsMinShares.repaint();
            this.panelInvestorsMinShares.revalidate();
            this.panelInvestorsMinShares.add(scrollPaneInveMinShares);
            this.panelInvestorsMaxCompanies.removeAll();
            this.panelInvestorsMaxCompanies.repaint();
            this.panelInvestorsMaxCompanies.revalidate();
            this.panelInvestorsMaxCompanies.add(scrollPaneInveMaxComp);
            this.panelInvestorsMinCompanies.removeAll();
            this.panelInvestorsMinCompanies.repaint();
            this.panelInvestorsMinCompanies.revalidate();
            this.panelInvestorsMinCompanies.add(scrollPaneInveMinComp);
            this.tableResults();
            this.newSim = false;
        }
    }

    @Override
    public void openSimulationFromDB() {
        MySQLCompanyDAO dbComp = new MySQLCompanyDAO();
        MySQLInvestorDAO dbInv = new MySQLInvestorDAO();
        MySQLTransactionDAO dbTran = new MySQLTransactionDAO();
        this.companies = dbComp.getCompanies();
        this.investors = dbInv.getInvestors();
        this.transactions = dbTran.getTransactions(this.investors, this.companies);
        this.registerComponent(new GUITableTransactions());
        this.registerComponent(new GUITableInvestors());
        this.registerComponent(new GUITableCompanies());
        JScrollPane scrollPaneT = new JScrollPane(this.tableTransactions.createTableTransactions(this.transactions));
        scrollPaneT.setPreferredSize(new Dimension(510, 300));
        JScrollPane ScrollPaneI = new JScrollPane(this.tableInvestors.createTableInvestors(this.investors));
        ScrollPaneI.setPreferredSize(new Dimension(510, 300));
        JScrollPane scrollPaneC = new JScrollPane(this.tableCompanies.createTableCompanies(this.companies));
        scrollPaneC.setPreferredSize(new Dimension(510, 300));
        JScrollPane scrollPaneCompMaxCapital = new JScrollPane(this.tableSummary.createTableCompaniesMaxCapital(this.transactions, this.companies));
        scrollPaneCompMaxCapital.setPreferredSize(new Dimension(245, 75));
        JScrollPane scrollPaneCompMinCapital = new JScrollPane(this.tableSummary.createTableCompaniesMinCapital(this.transactions, this.companies));
        scrollPaneCompMinCapital.setPreferredSize(new Dimension(245, 75));
        JScrollPane scrollPaneInveMaxShares = new JScrollPane(this.tableSummary.createTableInvestorsMaxShares(this.transactions, this.investors));
        scrollPaneInveMaxShares.setPreferredSize(new Dimension(245, 75));
        JScrollPane scrollPaneInveMinShares = new JScrollPane(this.tableSummary.createTableInvestorsMinShares(this.transactions, this.investors));
        scrollPaneInveMinShares.setPreferredSize(new Dimension(245, 75));
        JScrollPane scrollPaneInveMaxComp = new JScrollPane(this.tableSummary.createTableInvestorsMaxCompanies(this.transactions, this.companies, this.investors));
        scrollPaneInveMaxComp.setPreferredSize(new Dimension(245, 75));
        JScrollPane scrollPaneInveMinComp = new JScrollPane(this.tableSummary.createTableInvestorsMinCompanies(this.transactions, this.companies, this.investors));
        scrollPaneInveMinComp.setPreferredSize(new Dimension(245, 75));
        this.panelTransactions.removeAll();
        this.panelTransactions.repaint();
        this.panelTransactions.add(scrollPaneT);
        this.panelTransactions.revalidate();
        this.panelInvestors.removeAll();
        this.panelInvestors.repaint();
        this.panelInvestors.revalidate();
        this.panelInvestors.add(ScrollPaneI);
        this.panelCompanies.removeAll();
        this.panelCompanies.repaint();
        this.panelCompanies.revalidate();
        this.panelCompanies.add(scrollPaneC);
        this.panelCompaniesMaxcapital.removeAll();
        this.panelCompaniesMaxcapital.repaint();
        this.panelCompaniesMaxcapital.revalidate();
        this.panelCompaniesMaxcapital.add(scrollPaneCompMaxCapital);
        this.panelCompaniesMincapital.removeAll();
        this.panelCompaniesMincapital.repaint();
        this.panelCompaniesMincapital.revalidate();
        this.panelCompaniesMincapital.add(scrollPaneCompMinCapital);
        this.panelInvestorsMaxShares.removeAll();
        this.panelInvestorsMaxShares.repaint();
        this.panelInvestorsMaxShares.revalidate();
        this.panelInvestorsMaxShares.add(scrollPaneInveMaxShares);
        this.panelInvestorsMinShares.removeAll();
        this.panelInvestorsMinShares.repaint();
        this.panelInvestorsMinShares.revalidate();
        this.panelInvestorsMinShares.add(scrollPaneInveMinShares);
        this.panelInvestorsMaxCompanies.removeAll();
        this.panelInvestorsMaxCompanies.repaint();
        this.panelInvestorsMaxCompanies.revalidate();
        this.panelInvestorsMaxCompanies.add(scrollPaneInveMaxComp);
        this.panelInvestorsMinCompanies.removeAll();
        this.panelInvestorsMinCompanies.repaint();
        this.panelInvestorsMinCompanies.revalidate();
        this.panelInvestorsMinCompanies.add(scrollPaneInveMinComp);
        this.tableResults();
    }

    @Override
    public void tableResults() {
        this.panelSummary.removeAll();
        this.panelSummary.repaint();
        this.panelSummary.revalidate();
        this.panelSummary.add(this.panelS);
    }

    @Override
    public void barChartResults() {
        this.barChart.setPreferredSize(new Dimension(510, 300));
        this.panelSummary.removeAll();
        this.panelSummary.repaint();
        this.panelSummary.revalidate();
        this.panelSummary.add(this.barChart);
    }

    @Override
    public void openImputDialog() {
        boolean i = true;
    }

    @Override
    public ArrayList<Company> getCompanies() {
        return this.companies;
    }

    @Override
    public ArrayList<Investor> getInvestors() {
        return this.investors;
    }

    @Override
    public ArrayList<Transaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public void setPanelInvestors(GUITableInvestors panelInvestors) {
        this.tableInvestors = panelInvestors;
    }

    @Override
    public void setNumberCompanies(int numberCompanies) {
        this.numberCompanies = numberCompanies;
    }

    @Override
    public void setNumberInvestors(int numberInvestors) {
        this.numberInvestors = numberInvestors;
    }

    @Override
    public void setNewSim(boolean newSim) {
        this.newSim = newSim;
    }
}

