/*
 * Decompiled with CFR 0.152.
 */
package smsimulator.model;

import java.util.ArrayList;
import java.util.Collections;
import smsimulator.model.company.Company;
import smsimulator.model.investor.Investor;
import smsimulator.model.transaction.Transaction;

public class SimulationResultsSummary {
    public ArrayList<Double> getCompaniesCapital(ArrayList<Transaction> transactions, ArrayList<Company> companies) {
        ArrayList<Double> companiesCapital = new ArrayList<Double>();
        double value = 0.0;
        int i = 0;
        while (i <= companies.size()) {
            companiesCapital.add(value);
            ++i;
        }
        for (Transaction tran : transactions) {
            companiesCapital.set(tran.getCompany().getId(), companiesCapital.get(tran.getCompany().getId()) + tran.getTrasSharePrice());
        }
        companiesCapital.remove(0);
        return companiesCapital;
    }

    public ArrayList<Integer> getCompaniesMaxCapital(ArrayList<Double> companiesCapitals) {
        ArrayList<Integer> companiesMaxCapitals = new ArrayList<Integer>();
        double max = Collections.max(companiesCapitals);
        int i = 0;
        while (i < companiesCapitals.size()) {
            if (companiesCapitals.get(i) == max) {
                companiesMaxCapitals.add(i);
            }
            ++i;
        }
        return companiesMaxCapitals;
    }

    public ArrayList<Integer> getCompaniesMinCapital(ArrayList<Double> companiesCapitals) {
        ArrayList<Integer> companiesMinCapitals = new ArrayList<Integer>();
        double min = Collections.min(companiesCapitals);
        int i = 0;
        while (i < companiesCapitals.size()) {
            if (companiesCapitals.get(i) == min) {
                companiesMinCapitals.add(i);
            }
            ++i;
        }
        return companiesMinCapitals;
    }

    public ArrayList<Integer> getInvestorsNumberOfShares(ArrayList<Transaction> transactions, ArrayList<Investor> investors) {
        ArrayList<Integer> investorsNumberOfShares = new ArrayList<Integer>();
        int i = 0;
        while (i <= investors.size()) {
            investorsNumberOfShares.add(0);
            ++i;
        }
        for (Transaction tran : transactions) {
            investorsNumberOfShares.set(tran.getInvestor().getId(), investorsNumberOfShares.get(tran.getInvestor().getId()) + 1);
        }
        investorsNumberOfShares.remove(0);
        return investorsNumberOfShares;
    }

    public ArrayList<Integer> getInvestorsMaxShares(ArrayList<Integer> investorsNumberOfShares) {
        ArrayList<Integer> investorsMaxShares = new ArrayList<Integer>();
        int max = Collections.max(investorsNumberOfShares);
        int i = 0;
        while (i < investorsNumberOfShares.size()) {
            if (investorsNumberOfShares.get(i) == max) {
                investorsMaxShares.add(i);
            }
            ++i;
        }
        return investorsMaxShares;
    }

    public ArrayList<Integer> getInvestorsMinShares(ArrayList<Integer> investorsNumberOfShares) {
        ArrayList<Integer> investorsMinShares = new ArrayList<Integer>();
        int min = Collections.min(investorsNumberOfShares);
        int i = 0;
        while (i < investorsNumberOfShares.size()) {
            if (investorsNumberOfShares.get(i) == min) {
                investorsMinShares.add(i);
            }
            ++i;
        }
        return investorsMinShares;
    }

    public ArrayList<Integer> getNumberOfCompaniesByInvestor(ArrayList<Transaction> transactions, ArrayList<Investor> investors) {
        ArrayList<Integer> investorsIDs = new ArrayList<Integer>();
        ArrayList<Integer> companiesIDs = new ArrayList<Integer>();
        investorsIDs.add(0);
        companiesIDs.add(0);
        ArrayList<Integer> numberOfCompaniesByInvestor = new ArrayList<Integer>();
        int i = 0;
        while (i <= investors.size()) {
            numberOfCompaniesByInvestor.add(0);
            ++i;
        }
        for (Transaction tran : transactions) {
            boolean newCompany = true;
            int i2 = 0;
            while (i2 < investorsIDs.size()) {
                if (((Integer)investorsIDs.get(i2)).intValue() == tran.getInvestor().getId() && ((Integer)companiesIDs.get(i2)).intValue() == tran.getCompany().getId()) {
                    newCompany = false;
                    break;
                }
                ++i2;
            }
            if (!newCompany) continue;
            investorsIDs.add(tran.getInvestor().getId());
            companiesIDs.add(tran.getCompany().getId());
            numberOfCompaniesByInvestor.set(tran.getInvestor().getId(), numberOfCompaniesByInvestor.get(tran.getInvestor().getId()) + 1);
        }
        numberOfCompaniesByInvestor.remove(0);
        return numberOfCompaniesByInvestor;
    }

    public ArrayList<Integer> getInvestorsMaxCompanies(ArrayList<Integer> numberOfCompaniesByInvestor) {
        ArrayList<Integer> investorsMaxCompanies = new ArrayList<Integer>();
        int max = Collections.max(numberOfCompaniesByInvestor);
        int i = 0;
        while (i < numberOfCompaniesByInvestor.size()) {
            if (numberOfCompaniesByInvestor.get(i) == max) {
                investorsMaxCompanies.add(i);
            }
            ++i;
        }
        return investorsMaxCompanies;
    }

    public ArrayList<Integer> getInvestorsMinCompanies(ArrayList<Integer> numberOfCompaniesByInvestor) {
        ArrayList<Integer> investorsMinCompanies = new ArrayList<Integer>();
        int min = Collections.min(numberOfCompaniesByInvestor);
        int i = 0;
        while (i < numberOfCompaniesByInvestor.size()) {
            if (numberOfCompaniesByInvestor.get(i) == min) {
                investorsMinCompanies.add(i);
            }
            ++i;
        }
        return investorsMinCompanies;
    }
}

