/*
 * Decompiled with CFR 0.152.
 */
package smsimulator.model;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Random;
import smsimulator.model.company.Company;
import smsimulator.model.investor.Investor;
import smsimulator.model.transaction.Transaction;

public class TradingDaySimulation {
    public ArrayList<Company> companies = null;
    public ArrayList<Investor> investors = null;
    public ArrayList<Transaction> transactions = null;

    public ArrayList<Transaction> tradingSimulator(ArrayList<Company> companies, ArrayList<Investor> investors) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        LocalDate time = LocalDate.now();
        DateTimeFormatter formato = DateTimeFormatter.ofPattern("yyyy/MM-dd");
        String date = formato.format(time);
        ArrayList<Integer> sharesSold = new ArrayList<Integer>();
        ArrayList<Integer> sharesSoldEvery10Trans = new ArrayList<Integer>();
        int i = 0;
        while (i < companies.size()) {
            sharesSold.add(0);
            sharesSoldEvery10Trans.add(0);
            ++i;
        }
        Random r = new Random();
        boolean t = true;
        while (t) {
            t = false;
            ArrayList<Company> companiesTrans = this.getCompaniesWithShares(companies);
            if (companiesTrans == null || companiesTrans.size() <= 0) continue;
            int indexComp = r.nextInt(companiesTrans.size());
            Company comp = companiesTrans.get(indexComp);
            double minSharePrice = this.getMinSharePrice(companiesTrans);
            ArrayList<Investor> investorsTrans = this.getInvestorsWithEnoughBudget(investors, minSharePrice);
            if (investorsTrans == null || investorsTrans.size() <= 0) continue;
            t = true;
            ArrayList<Investor> investorsCurrentTras = this.getInvestorsWithEnoughBudget(investorsTrans, comp.getsharePrice());
            if (investorsCurrentTras == null || investorsCurrentTras.size() <= 0) continue;
            int indexInv = r.nextInt(investorsCurrentTras.size());
            Investor inv = investorsCurrentTras.get(indexInv);
            transactions.add(new Transaction(inv, comp, comp.getsharePrice(), date));
            companies.get(indexComp).setShares(comp.getShares() - 1);
            investors.get(indexInv).setBudget(inv.getBudget() - comp.getsharePrice());
            sharesSold.set(indexComp, (Integer)sharesSold.get(indexComp) + 1);
            sharesSoldEvery10Trans.set(indexComp, (Integer)sharesSoldEvery10Trans.get(indexComp) + 1);
            if ((Integer)sharesSold.get(indexComp) != 0 && (Integer)sharesSold.get(indexComp) % 10 == 0) {
                companies.get(indexComp).setSharePrice(comp.getsharePrice() * 2.0);
            }
            if (this.sumAll(sharesSold) == 0 || this.sumAll(sharesSold) % 10 != 0) continue;
            int i2 = 0;
            while (i2 < companies.size()) {
                if ((Integer)sharesSoldEvery10Trans.get(i2) == 0) {
                    double price = companies.get(i2).getsharePrice();
                    double newPrice = price - price * 0.02;
                    companies.get(i2).setSharePrice(newPrice);
                }
                ++i2;
            }
        }
        return transactions;
    }

    public ArrayList<Company> getCompaniesWithShares(ArrayList<Company> companies) {
        ArrayList<Company> c = new ArrayList<Company>();
        int i = 0;
        while (i < companies.size()) {
            if (companies.get(i).getShares() > 0) {
                c.add(companies.get(i));
            }
            ++i;
        }
        return c;
    }

    public ArrayList<Investor> getInvestorsWithEnoughBudget(ArrayList<Investor> investors, double minBudget) {
        ArrayList<Investor> inv = new ArrayList<Investor>();
        int i = 0;
        while (i < investors.size()) {
            if (investors.get(i).getBudget() >= minBudget) {
                inv.add(investors.get(i));
            }
            ++i;
        }
        return inv;
    }

    public double getMinSharePrice(ArrayList<Company> companies) {
        double minSharePrice = companies.get(0).getsharePrice();
        int minIndex = 0;
        int i = 1;
        while (i < companies.size()) {
            if (companies.get(i).getsharePrice() < minSharePrice) {
                minSharePrice = companies.get(i).getsharePrice();
                minIndex = i;
            }
            ++i;
        }
        return minSharePrice;
    }

    public int sumAll(ArrayList<Integer> numbers) {
        int sum = 0;
        for (int number : numbers) {
            sum += number;
        }
        return sum;
    }
}

