<%-- 
    Document   : index
    Created on : 12-Mar-2019, 12:29:34
    Author     : adelo
--%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>JSP Page</title>
        <link rel="stylesheet" href="./layout.css">
    </head>
    <body>
        <!-- Site navigation menu -->
        <ul class="navbar">
          <li><a href="#web_service">Web services</a>
          <li><a href="#tech">Some technologies used in WS</a>
          <li><a href="#creating">Creating and Deploying a WS</a>
          <li><a href="#testing">Testing a WS</a>
          <li><a href="#consuming">Consuming the Web Service</a>
          <li><a href="#web_service_ex">Web Service examples</a>
        </ul>
        
      <center>
      <font size="4">
            <br/><br/>
            <font size="6"><b>An introduction to Web services</b></font>
            <br/><br/>
            <b>Ana Paula Neves Ferreira - 2016371</b>
            <br/>
            <b>Adelo Vieira - 2017279</b>
            <br/><br/>
            <b>Big Data Integration</b>
            <br/><br/><br/><br/>
      </font>
      </center>

        
    <h2 id="web_service" style="color:black;">Web services</h2>
    <!-- <h></h> -->
    <p> Web Services are a set of methods that are called by other programs using the web technology. The Web Service is used to transfer data through communication protocols for different platforms.

    <p> Web services communicate using different technologies, such as:
        <ul>
            <li>XML, JSON and HTTP</li>
            <li>Simple Object Access Protocol (SOAP): An XML-based protocol that allows web services and clients to communicate in a platform-independent manner</li>
        </ul> 

        
    <h3>Basic concepts of a Web service:</h3> 

        <ul>
            <li> Remote machine or server: The computer on which a web service resides</li>
            <li> A client application that accesses a web service sends a method call over a network to the remote machine, which processes the call and returns a response over the network to the application</li>
            <li> Publishing (deploying) a web service: Making a web service available to receive client requests.</li>
            <li> Consuming a web service: Using a web service from a client application.</li>
            <li> In Java, a web service is implemented as a class that resides on a server.</li>
        </ul>
    
    <h3>An application that consumes a web service (client) needs:</h3> 
        <ul>
            <li> An object of a proxy class for interacting with the web service.</li>
            <li> The proxy object handles the details of communicating with the web service on the client's behalf</li>
        </ul>
    
    <img src="./Interaction_between_a_web_service_client_and_a_web_service.png" alt="Smiley face" height="200" class="center">

        
    <h3>JAX-WS:</h3> 
    <p> The Java API for XML Web Services (JAX-WS) is a Java programming language API for creating web services, particularly SOAP services. JAX-WS is one of the Java XML programming APIs. It is part of the Java EE platform.
        <ul>
            <li> Requests to and responses from web services are typically transmitted via SOAP.</li>
            <li> Any client capable of generating and processing SOAP messages can interact with a web service, regardless of the language in which the web service is written.</li>
        </ul>
    
    
   
    <br></br><br></br>
    <h2 id="tech" style="color:black;">Some technologies used in consuming a Web Service</h2>
    
    <h3>Java Develop Kit (JDK):</h3> 
    <p> Java Develop Kit (JDK) is a tool used to facilitate the development of a java program, the resources available on the JDK are: Java vitual machine, library and the compiler.
    
    <h3>Netbeans:</h3> 
    <p> Netbeans is an integrated development environment, offering to the web developers the necessary tools for web applications and mobile apps written in Java, PHP, Rails, etc.


    <h3>Soap:</h3> 
    <p> Soap(Simple Object Acess Protocol) is a protocol that transfer messages in XML format used in message exchange between applications and web services.
    <p> Soap allows web services and clients to communicate in a platform-independent manner.
       
    
    <h3>XML:</h3> 
    <p> Extensible Markup Language (XML) is a code used to describe data over the web, it can be used by anyone to share and retrieve data in a consistent way.



   <br></br><br></br>
   <h2 id="creating" style="color:black;">Creating and Deploying a WS using NetBeans</h2>
   
   <h3>We first need to to do some configuration in NetBeans:</h3> 
        <ul>
            <li> Go to /usr/local/netbeans-8.2/etc/netbeans.conf:</li>
            <li> Find the line: netbeans_default_options</li>
            <li> If -J-Djavax.xml.accessExternalSchema=all is not between the quotes then paste it in</li>
        </ul>   
   
   <h3>If you are deploying to the GlassFish Server:</h3> 
        <ul>
            <li> You need to modify the configuration file of the GlassFish Server (domain.xml):</li>
            <li> /usr/local/glassfish-4.1.1/glassfish/domains/domain1/config/domain.xml</li>
            <li> Find: java-config </li>
            <li> Check the jvm-options for the following configuration: -Djavax.xml.accessExternalSchema=all</li>
            <li> It should be there by default, if not paste it in, save file and exit</li>
            <li> You can now start Netbeans IDE</li>
        </ul>      
   
        
   <h3>Create a Web Service in NetBeans- Locally:</h3> 
        <ul>
            <li> Choose File > New Project:</li>
            <li> Select Web Application from the Java Web category</li>
            <li> Change Project Name: to CalculatorWSApplication</li>
            <li> Set the server to GlassFish 4.1.1</li>
            <li> Set Java EE Version: Java EE 7 Web</li>
            <li> Set Context path: /CalculatorWSApplication</li>
            <li> After that you should now have a project created in the Projects view on the left hand side.</li>
        </ul>      
   
   
   <h3>Creating a WS from a Java Class:</h3> 
        <ul>
            <li> Right-click the CalculatorWSApplication node and choose New > Web Service.</li>
            <li> Click Next</li>
            <li> Name the web service CalculatorWS and type com.hduser.calculator in Package. Leave Create Web Service from Scratch selected.</li>
            <li> Select Implement Web Service as a Stateless Session Bean.</li>
            <li> Click Finish. The Projects window displays the structure of the new web service and the source code is shown in the editor area. A default hello web service is created by Netbeans.</li>
        </ul>         

 
   <h3>Adding an Operation to the WS:</h3> 
        <ul>
            <li> Change to the Design view in the editor.</li>
            <li> Click the Add operation button.</li>
            <li> In the upper part of the Add Operation dialog box, type add in Name and type int' in the Return Type drop-down list.</li>
            <li> In the lower part of the Add Operation dialog box, click Add and create a parameter of type int named num_1.</li>
            <li> Click Add again and create a parameter of type int called num_2.</li>
            <li> Click OK at the bottom of the panel to add the operation.</li>
            <li> Remove the default hello operation: Right click on hello operation and choose: Remove Operation</li>
            <li> Click on the source view to go back to view the code in the editor.</li>
            <li> You will see the default hello code is gone and the new add method is now there instead.</li>
            <li> Now we have to alter the code to look like this.</li>
        </ul>         

        <img src="./code.png" alt="Smiley face" width="650" class="center">
   
        <ul>
            <li> To test the Web service drop down the Web Services directory and right click on CalculatorWSApplication.</li>
            <li> Choose Test Web service.</li>
            <li> Netbeans throws an error: It is letting us know that we have not deployed our Web Service.</li>
            <li> Right click on the main Project node and select deploy</li>
        </ul>            
 
        
        <br></br><br></br>
        <h2 id="testing" style="color:black;">Testing the Web service</h2>
        <ul>
            <li> Deploying the Web Service will automatically start the GlassFish server. Allow the server to start, this will take a little while. You can check the progress by clicking on the GlassFish tab at the bottom of the IDE.</li>
            <li> Wait until you see: «CalculatorWSApplication was successfully deployed in 9,912 milliseconds»</li>
            <li> Now you can right click on the Web Service as before and choose Test Web Service.</li>
            <li> The browser will open and you can now test the Web service and view the WSDL file.</li>
            <li> You can also view the Soap Request and Response.</li>
        </ul>                 
        
        
        <br></br><br></br>
        <h2 id="consuming" style="color:black;">Consuming the Web Service</h2>
        <ul>
            <li> Now that we have a web service we need a client to consume it.</li>
            <li> Choose File > New Project</li>
            <li> Select Web Application from the Java Web category</li>
            <li> Name the project CalculatorWSJSPClient</li>
            <li> Leave the server and java version as before and click Finish.</li>
            <li> Expand the Web Pages node under the project node and delete index.html.</li>
            <li> Right-click the Web Pages node and choose New > JSP in the popup menu. </li>
            <li> Type index for the name of the JSP file in the New File wizard. Click Finish to create the JSP (Java Server Page)</li>
            <li> Right-click the CalculatorWSJSPClient node and choose New > Web Service Client. </li>
            <li> Select Project as the WSDL source. Click Browse. Browse to the CalculatorWS web service in the CalculatorWSApplication project. When you have selected the web service, click OK.</li>
            <li> Do not select a package name. Leave this field empty.</li>
            <li> Leave the other settings as default and click Finish.</li>
            <li> The WSDL gets parsed and generates the .java</li>
            <li> The Web Service References directory now contains the add method we created in our web service.</li>
            <li> Drag and drop the add method just below the H1 tags in index.jsp</li>
            <li> The Code will be automatically generated.</li>
            <li> Change the values of num_1 and num_2 to any two numbers e.g. 5 and 5 as per test earlier.</li>
            <li> Remove the TODO line from the catch block of the code and paste in:</li>
            <li> out.println("exception" + ex);</li>
            <li> If there is an error this will help us identify the problem.</li>
            <li> IMPORTANT Once you close Netbeans you are shutting down your server. If you want to reuse a Web Service you must re-deploy.</li>
        </ul>                 
        
        
        
        
    <br></br><br></br>
    <h2 id="web_service_ex" style="color:black;">Web service examples</h2>
        
        <%
            java.lang.String input = null;
            input = request.getParameter("input");
        %>
         
        <h3>Sort Web Service Tester</h3>
        Please enter a list of numbers:<br></br>
        org.tempuri.IService port = service.getBasicHttpBindingIService()
	<form class='form-style' action="index.jsp#web_service_ex" method="post">
            <input class='button' type="submit" name="submit" value="Sort"/>(
            <input type="text" name="input" value="<%if (input != null){out.println(input);}%>"/>
            <span class="error"><?php echo $usernameErr;?></span>) = 
	
        
            <%-- start web service invocation --%>
            <%
                try {
                    org.tempuri.Service service = new org.tempuri.Service();
                    org.tempuri.IService port = service.getBasicHttpBindingIService();
                    // TODO process result here
                    java.lang.String code = port.getKey();
                    // out.println("Result = "+code);
                } catch (Exception ex) {
                    // TODO handle custom exceptions here
                }
            %>
            <%-- end web service invocation --%>



            <%-- start web service invocation --%>
            <!--<hr/>-->
            <%
                try {
                    org.tempuri.Service service = new org.tempuri.Service();
                    org.tempuri.IService port = service.getBasicHttpBindingIService();
                     // TODO initialize WS operation arguments here
                    // java.lang.String input2 = "12 23 40 34 11 5 6";
                    java.lang.String userKey = port.getKey();
                    // TODO process result here
                    java.lang.String result = port.mergeSort(input, userKey);
                    out.println(result);
                } catch (Exception ex) {
                    // TODO handle custom exceptions here
                }
            %>
            <%-- end web service invocation --%>
        </form>
        

        
                <br></br><br></br>
        <%
            String num1_string  = null;
            String num2_string  = null;
            // https://www.tutorialspoint.com/jsp/jsp_form_processing.htm
            num1_string = request.getParameter("num1_string");
            num2_string = request.getParameter("num2_string");
        %>
        
        
        <h3>Calculator Web Service Tester</h3>
        public abstract int com.adelo.calculator.CalculatorWS.add(int,int)
	<form class='form-style' action="index.jsp#web_service_ex" method="post">
            <input class='button' type="submit" name="submit" value="add"/>(
            <input type="text" name="num1_string" value="<%if (num1_string != null && num2_string != null){out.println(num1_string);}%>"/>
            <span class="error"><?php echo $usernameErr;?></span>,
            <input type="text" name="num2_string" value="<%if (num1_string != null && num2_string != null){out.println(num2_string);}%>"/>
            <span class="error"><?php echo $usernameErr;?></span>) =
	
        
            <%-- start web service invocation --%>
            <%
                
                if (num1_string != null && num2_string != null){
                    try {   
                        int num1 = Integer.parseInt(num1_string);
                        int num2 = Integer.parseInt(num2_string);

                        com.adelo.calculator.CalculatorWS_Service service = new com.adelo.calculator.CalculatorWS_Service();
                        com.adelo.calculator.CalculatorWS port = service.getCalculatorWSPort();

                        int result = port.add(num1, num2);
                        out.println(result);
                    } catch (Exception ex) {
                        out.println("exception" + ex);
                    }
                }
                else{
                    out.println("Enter the required paramethers, then sumit...");
                }
            %>
            <%-- end web service invocation --%>
        </form>
        
        
          

        <!-- Sign and date the page, it's only polite! -->
        <br></br><br></br>
        <p style="color: rgb(102, 0, 0);">Notice that we have not implemented a 
            response.jsp page that opens and shows the result of the query performed 
            by the WS. We have used an approach where the response is redirected 
            to the same file (index.jps) so the results of the query are shown in 
            the same page. We thinks this is a more convenient approach to show the results.</p>
        
        <p style="color: rgb(102, 0, 0);">Most of the concepts and procedures shown in 
            this page were taken from the material provided during the Big Data Integration lecture.</p>
        
        <p style="color: rgb(102, 0, 0);">In addition to the NetBeans project used to generate this JSP page,
        we have also provided the CalculatorWSApplication NetBeans project. This project contains the Calculator Web Service, which was locally consumed
        by the second Web Service example shown in this page.</p>
        <address>
            March 11, 2019<br>
            Made by Ana Paula Neves Ferreira and Adelo Vieira<br>
            Lecture: Dr. Muhammad Iqbal<br>
            College of computing technology - Dublin<br>
        </address>
        <br></br><br></br>
    </body>
</html>
